<?php 
require 'inc/Header.php';
?>
<!-- Loader ends-->
<!-- page-wrapper Start-->
<div class="page-wrapper compact-wrapper" id="pageWrapper">
  <!-- Page Header Start-->
  <?php require 'inc/Navbar.php';?>
  <!-- Page Header Ends-->
  <!-- Page Body Start-->
  <div class="page-body-wrapper">
    <!-- Page Sidebar Start-->
    <?php require 'inc/Sidebar.php';?>
    <!-- Page Sidebar Ends-->
    <div class="page-body">
      <div class="container-fluid">
        <div class="page-title">
          <div class="row">
            <div class="col-sm-6">
              <h3><?php echo $lang['ParcelHistoryList']; ?></h3>
            </div>
          </div>
        </div>
      </div>
      <!-- Container-fluid starts-->
      <div class="container-fluid dashboard-default">
        <div class="row">
          <div class="col-sm-12">
            <div class="card">
              <div class="card-body">
                <div class="table-responsive">
                  <table class="display" id="basic-1">
                    <thead>
                      <tr>
                        <th><?php echo $lang['SrNo']; ?></th>
                        <th><?php echo $lang['TripDate']; ?></th>
                        <th><?php echo $lang['SenderName']; ?></th>
                        <th><?php echo $lang['ReceiverName']; ?></th>
                        <th><?php echo $lang['FromCity']; ?></th>
                        <th><?php echo $lang['ToCity']; ?></th>
                        <th><?php echo $lang['ParcelWeight']; ?></th>
                        <th><?php echo $lang['Distance']; ?></th>
                        <th><?php echo $lang['Price']; ?></th>
                        <th><?php echo $lang['WalletAmount']; ?></th>
                        <th><?php echo $lang['PaymentMethod']; ?></th>
                        <th><?php echo $lang['Status']; ?></th>
                        <th><?php echo $lang['BusNo']; ?></th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php 
                      $sid  = $sdata['id'];
                      $stmt = $h->queryfire("SELECT * FROM tbl_parcel WHERE operator_id = $sid ORDER BY id DESC");
                      $i    = 0;
                      while ($row = $stmt->fetch_assoc()) {
                          $i++;
                          // Related look‑ups
                          $bus      = $h->queryfire("SELECT bno FROM tbl_bus WHERE id = " . intval($row['bus_id']))->fetch_assoc();
                          $fromCity = $h->queryfire("SELECT title FROM tbl_city WHERE id = " . intval($row['from_city']))->fetch_assoc();
                          $toCity   = $h->queryfire("SELECT title FROM tbl_city WHERE id = " . intval($row['to_city']))->fetch_assoc();
                          $pname    = $h->queryfire("SELECT title FROM tbl_payment_list WHERE id = " . intval($row['p_method_id']))->fetch_assoc();
                      ?>
                      <tr>
                        <td><?php echo $i; ?></td>
                        <td><?php echo $row['trip_date']; ?></td>
                        <td><?php echo $row['sender_name']; ?></td>
                        <td><?php echo $row['receiver_name']; ?></td>
                        <td><?php echo $fromCity['title'] ?? ''; ?></td>
                        <td><?php echo $toCity['title'] ?? ''; ?></td>
                        <td><?php echo $row['parcel_weight']; ?></td>
                        <td><?php echo $row['distance']; ?></td>
                        <td><?php echo $row['price']; ?></td>
                        <td><?php echo $row['wall_amt']; ?></td>
                        <td><?php echo $pname['title'] ?? ''; ?></td>
                        <td><?php echo $row['status']; ?></td>
                        <td><?php echo $bus['bno'] ?? ''; ?></td>
                      </tr>
                      <?php } ?>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
      <!-- Container-fluid Ends-->
    </div>
    <!-- footer start-->
  </div>
</div>
<!-- latest jquery-->
<?php require 'inc/Footer.php'; ?>
<!-- login js-->
</body>
</html>
